/*
 * Decompiled with CFR 0.152.
 */
package Modem;

import Modem.Logger;
import Modem.SMS_Message;
import com.cinterion.io.ATCommand;
import com.cinterion.io.ATCommandFailedException;
import com.cinterion.io.ATCommandListener;
import com.cinterion.io.ATStringConverter;
import java.util.Date;
import java.util.Vector;

public class SMS_Worker
extends Thread {
    private boolean _bActive = true;
    private ATListener lt = null;
    private ATCommand ATCmd = null;
    private static Vector send_list = new Vector();
    private boolean bBreak = false;
    private Vector subscriber_list = new Vector();

    public boolean get_Active() {
        return this._bActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RegisterSMS_Receiver(ISMS_Receiver receiver) {
        Vector vector = this.subscriber_list;
        synchronized (vector) {
            this.subscriber_list.addElement(receiver);
        }
    }

    public String GetOwnPhoneNumber() {
        String phoneNumber = "";
        try {
            String response = this.ATCmd.send("AT+CNUM\r");
            int posComma1 = response.indexOf(",");
            int posComma2 = response.indexOf(",", posComma1 + 1);
            if (posComma1 != -1 && posComma2 != -1) {
                phoneNumber = response.substring(posComma1 + 2, posComma2 - 1);
            }
        }
        catch (ATCommandFailedException e) {
            System.out.println(e.getMessage());
        }
        return phoneNumber;
    }

    public String GetSIMCardIdentificationNumber() {
        String number = "";
        try {
            String response = this.ATCmd.send("AT^SCID\r");
            int posColon = response.indexOf(":");
            int posCR = response.indexOf("\r", posColon + 1);
            if (posColon != -1 && posCR != -1) {
                number = response.substring(posColon + 2, posCR - 1);
            }
        }
        catch (ATCommandFailedException e) {
            System.out.println(e.getMessage());
        }
        return number;
    }

    public String get_signal_quality() {
        String retval = "0";
        try {
            String answer = this.ATCmd.send("AT+CSQ\r");
            int posColon = answer.indexOf(":");
            int posComma = answer.indexOf(",", posColon);
            if (posColon != -1 && posComma != -1 && posComma > posColon) {
                retval = answer.substring(posColon + 1, posComma);
            }
        }
        catch (Exception excp) {
            System.out.println(excp.getMessage());
        }
        return retval;
    }

    public String get_fw_version() {
        String retval = "0";
        try {
            String answer;
            retval = answer = this.ATCmd.send("ATI\r");
        }
        catch (Exception excp) {
            System.out.println(excp.getMessage());
        }
        return retval;
    }

    public String get_network_info() {
        String retval = "0";
        try {
            String answer = this.ATCmd.send("at^smonc\r");
            retval = answer.substring(18, answer.length() - 24);
        }
        catch (Exception excp) {
            System.out.println(excp.getMessage());
        }
        return retval;
    }

    public String get_watchdog_setting() {
        String retval = "-";
        try {
            String answer = this.ATCmd.send("AT^SCFG=\"userware/watchdog\"\r");
            int pos1 = answer.indexOf("Userware/Watchdog");
            int pos2 = answer.indexOf("\n", pos1);
            retval = pos1 != -1 && pos2 != -1 && pos2 > pos1 ? answer.substring(pos1 + 20, pos2 - 2) : "Pos1: " + pos1 + " Pos2: " + pos2;
        }
        catch (Exception excp) {
            System.out.println(excp.getMessage());
            retval = excp.getMessage();
        }
        return retval;
    }

    public String get_otap_flag() {
        String retval = "-";
        try {
            String answer = this.ATCmd.send("AT^SJOTAP?\r");
            int pos1 = answer.indexOf("^SJOTAP:");
            int pos2 = answer.lastIndexOf(44);
            retval = pos1 != -1 && pos2 != -1 && pos2 > pos1 ? answer.substring(pos1 + 21, pos2 - 1) : "Pos1: " + pos1 + " Pos2: " + pos2;
        }
        catch (Exception excp) {
            System.out.println(excp.getMessage());
            retval = excp.getMessage();
        }
        return retval;
    }

    public String get_operator_information() {
        String retval = "-";
        try {
            String answer = this.ATCmd.send("at+cops=?\r");
            int pos1 = answer.indexOf("+COPS:");
            int pos2 = answer.indexOf("\n", pos1);
            retval = pos1 != -1 && pos2 != -1 && pos2 > pos1 ? answer.substring(pos1 += 7, pos2 - 2) : "Pos1: " + pos1 + " Pos2: " + pos2 + answer;
        }
        catch (Exception excp) {
            System.out.println(excp.getMessage());
            retval = excp.getMessage();
        }
        return retval;
    }

    public boolean select_operator(String operator_id) {
        boolean retval = false;
        try {
            String request = "AT+COPS=4,2,\"" + operator_id + "\"\r";
            String answer = this.ATCmd.send(request);
            int pos1 = answer.indexOf("OK");
            retval = pos1 != -1;
        }
        catch (Exception excp) {
            System.out.println(excp.getMessage());
            retval = false;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process_new_message(String slot) {
        try {
            String response = this.ATCmd.send("AT+CMGR=" + slot + "\r");
            int posComma1 = response.indexOf(",");
            int posComma2 = response.indexOf(",", posComma1 + 1);
            int posCRLF = response.indexOf("\r\n", posComma2);
            int posEnd = response.indexOf("\r\nOK\r\n");
            if (posComma1 == -1 || posComma2 == -1 || posCRLF == -1 || posEnd == -1) {
                System.out.println("Invalid string format in response: " + response + posComma1 + posComma2 + posCRLF);
                return;
            }
            this.ATCmd.send("AT+CMGD=" + slot + "\r");
            String phoneNumber = response.substring(posComma1 + 2, posComma2 - 1);
            String message = response.substring(posCRLF + 2, posEnd);
            Vector vector = this.subscriber_list;
            synchronized (vector) {
                for (int i = 0; i < this.subscriber_list.size(); ++i) {
                    ISMS_Receiver receiver = (ISMS_Receiver)this.subscriber_list.elementAt(i);
                    receiver.SMS_ReceivedEvent(phoneNumber, message);
                }
            }
        }
        catch (ATCommandFailedException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
    }

    public String sendAT(String str) {
        try {
            str = this.ATCmd.send(str + "\r".toUpperCase());
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ATCommandFailedException e) {
            e.printStackTrace();
        }
        return str;
    }

    private boolean enterpin(String pin) {
        try {
            String response = this.ATCmd.send("AT+CPIN?\r");
            if (response.indexOf("READY") > -1) {
                System.out.println("no PIN required");
                return true;
            }
            System.out.println("Response: " + response);
            System.out.println("enter PIN " + pin);
            this.ATCmd.send("AT+CPIN=" + pin + "\r");
            response = this.ATCmd.send("AT+CPIN?\r");
            if (response.indexOf("READY") > -1) {
                System.out.println("PIN accepted");
                return true;
            }
            System.out.println(response);
            System.out.println("PIN rejected");
            return false;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ATCommandFailedException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void initialize() {
        try {
            String slot;
            int pos_comma;
            this.ATCmd.send("AT+CMEE=1\r");
            this.ATCmd.send("AT^SCFG=\"Userware/Autostart/Delay\",\"\",\"350\"\r");
            this.ATCmd.send("AT^SLED=2,50\r");
            this.ATCmd.send("AT+CMGF=1\r");
            this.ATCmd.send("AT+CPMS=\"MT\"\r");
            this.ATCmd.send("AT+CNMI=1,1\r");
            this.ATCmd.send("AT^SJOTAP=\"3119\",,,,,,,,,,,on,\r");
            String response = this.ATCmd.send("AT+CMGL=\"REC READ\"\r");
            int pos = 0;
            while ((pos = response.indexOf("+CMGL: ")) != -1) {
                pos_comma = response.indexOf(",", pos);
                slot = response.substring(pos + 7, pos_comma);
                this.ATCmd.send("AT+CMGD=" + slot + "\r");
                response = response.substring(pos_comma);
            }
            response = this.ATCmd.send("AT+CMGL=\"REC UNREAD\"\r");
            pos = 0;
            while ((pos = response.indexOf("+CMGL: ")) != -1) {
                pos_comma = response.indexOf(",", pos);
                slot = response.substring(pos + 7, pos_comma);
                this.process_new_message(slot);
                response = response.substring(pos_comma);
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ATCommandFailedException e) {
            e.printStackTrace();
        }
    }

    public SMS_Worker(String pin) {
        try {
            this.lt = new ATListener();
            this.ATCmd = new ATCommand(false);
            this.ATCmd.addListener(this.lt);
            this.enterpin(pin);
            this.initialize();
        }
        catch (ATCommandFailedException e) {
            System.out.println(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean SendMessage(String telNumber, String message) {
        boolean retval = false;
        SMS_Message msg = new SMS_Message();
        msg.telephoneNumber = telNumber;
        msg.message = ATStringConverter.Java2GSM((String)message);
        msg.date = new Date(System.currentTimeMillis());
        Vector vector = send_list;
        synchronized (vector) {
            send_list.addElement(msg);
            send_list.notify();
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            do {
                SMS_Message msg = null;
                Vector vector = send_list;
                synchronized (vector) {
                    if (send_list.isEmpty()) {
                        try {
                            send_list.wait();
                        }
                        catch (InterruptedException e) {}
                    } else {
                        msg = (SMS_Message)send_list.firstElement();
                        send_list.removeElement(msg);
                    }
                }
                if (msg == null) continue;
                char controlZ = '\u001a';
                Logger.info(this.getClass(), ((Object)msg.date).toString() + ": send message: " + msg.message + " to client: " + msg.telephoneNumber);
                this.sendAT("at+cmgs=\"" + msg.telephoneNumber + "\"\r");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.sendAT(msg.message + controlZ);
            } while (!this.bBreak);
        }
        catch (Exception excp) {
            Logger.info(this.getClass(), excp.getMessage());
            excp.printStackTrace();
        }
        this._bActive = false;
        Logger.info(this.getClass(), "SMS workerthread ended.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Vector vector = send_list;
        synchronized (vector) {
            this.bBreak = true;
            send_list.notify();
        }
    }

    class ATListener
    implements ATCommandListener {
        ATListener() {
        }

        public void ATEvent(String Event) {
            System.out.println("URC-Event: " + Event);
            if (Event.indexOf("+CMTI") != -1) {
                String slot = Event.substring(Event.indexOf(",") + 1);
                System.out.println("read message in slot #" + slot);
                SMS_Worker.this.process_new_message(slot);
            }
        }

        public void RINGChanged(boolean SignalState) {
            System.out.println("RING-Event: " + SignalState);
        }

        public void DCDChanged(boolean SignalState) {
            System.out.println("DCD-Event: " + SignalState);
        }

        public void DSRChanged(boolean SignalState) {
            System.out.println("DSR-Event: " + SignalState);
        }

        public void CONNChanged(boolean SignalState) {
            System.out.println("CONN-Event: " + SignalState);
        }
    }

    public static interface ISMS_Receiver {
        public void SMS_ReceivedEvent(String var1, String var2);
    }
}

