/*
 * Decompiled with CFR 0.152.
 */
package Modem;

import Modem.Configuration;
import Modem.InputOutput;
import Modem.KeyValuePair;
import Modem.Logger;
import Modem.SMS_Worker;
import com.cinterion.io.ATStringConverter;
import com.cinterion.misc.Watchdog2;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class MainThread
extends MIDlet
implements SMS_Worker.ISMS_Receiver {
    private static MainThread _instance;
    private SMS_Worker _sms_worker = null;
    private InputOutput _ioController;
    private long _time_last_boot = 0L;
    private String _swVersion = "";
    private String _apn = "";
    private String _username = "";
    private String _password = "";
    private String _gsmNumber = "";
    private int _secondsOfOperation = 0;
    private String _stationId = "";
    private String[] _msg = new String[]{"Container error", "Container nearly full", "Container full"};
    private String _destHost = "52.233.167.156";
    private String _destPort = "620";
    private int _actualMsgId = 0;
    private boolean _bBreak = false;
    private SocketConnection _sc;
    private InputStream _is;
    private OutputStream _os;
    protected byte[] _indata = new byte[1024];
    private Vector _alertUsers = new Vector();
    private final int WATCHDOG_TIME;
    private final int INIT_TIME;
    private final int INPUT_ERROR;
    private final int INPUT_NEARLY_FULL;
    private final int INPUT_FULL;
    private final int INPUT_OPERATION;
    private final int MIN_FRAME_SIZE;
    private Watchdog2 _watchdog = new Watchdog2();

    private boolean LoadConfiguration() {
        try {
            Vector settings = Configuration.load();
            if (settings == null) {
                return false;
            }
            for (int i = 0; i < settings.size(); ++i) {
                KeyValuePair pair = (KeyValuePair)settings.elementAt(i);
                if ("apn".equals(pair.getKey().toLowerCase())) {
                    this._apn = pair.getValue().trim();
                    continue;
                }
                if ("username".equals(pair.getKey().toLowerCase())) {
                    this._username = pair.getValue().trim();
                    continue;
                }
                if ("password".equals(pair.getKey().toLowerCase())) {
                    this._password = pair.getValue().trim();
                    continue;
                }
                if ("gsmnumber".equals(pair.getKey().toLowerCase())) {
                    this._gsmNumber = pair.getValue().trim();
                    continue;
                }
                if ("stationid".equals(pair.getKey().toLowerCase())) {
                    this._stationId = pair.getValue().trim();
                    continue;
                }
                if ("alertuser".equals(pair.getKey().toLowerCase())) {
                    this._alertUsers.addElement(pair.getValue().trim());
                    continue;
                }
                if (!"secondsofoperation".equals(pair.getKey().toLowerCase())) continue;
                this._secondsOfOperation = Integer.parseInt(pair.getValue(), 10);
            }
        }
        catch (Exception excp) {
            System.out.println(excp.getMessage());
            excp.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean SaveConfiguration() {
        boolean retval = false;
        try {
            Vector<KeyValuePair> config = new Vector<KeyValuePair>();
            KeyValuePair pair = new KeyValuePair("apn", this._apn);
            config.addElement(pair);
            pair = new KeyValuePair("username", this._username);
            config.addElement(pair);
            pair = new KeyValuePair("password", this._password);
            config.addElement(pair);
            pair = new KeyValuePair("gsmnumber", this._gsmNumber);
            config.addElement(pair);
            pair = new KeyValuePair("stationid", this._stationId);
            config.addElement(pair);
            pair = new KeyValuePair("secondsofoperation", Integer.toString(this._secondsOfOperation));
            config.addElement(pair);
            for (int i = 0; i < this._alertUsers.size(); ++i) {
                pair = new KeyValuePair("alertuser", this._alertUsers.elementAt(i).toString());
                config.addElement(pair);
            }
            retval = Configuration.save(config);
        }
        catch (Exception excp) {
            System.out.println(excp.getMessage());
            excp.printStackTrace();
            return false;
        }
        return retval;
    }

    public void SMS_ReceivedEvent(String phoneNumber, String message) {
        try {
            int posStart;
            String str = "Received new message: '" + message + "' from:" + phoneNumber;
            System.out.println(str);
            message = ATStringConverter.GSM2Java((String)message);
            if (message.toLowerCase().indexOf("send signal") != -1) {
                long uptime = System.currentTimeMillis() - this._time_last_boot;
                message = "Signalstaerke = " + this._sms_worker.get_signal_quality();
                message = message + "\r\nWatchdog = " + this._sms_worker.get_watchdog_setting();
                message = message + "\r\nOTAP = " + this._sms_worker.get_otap_flag();
                message = message + "\r\nUptime: " + (uptime /= 1000L);
                message = message + "\r\nSwVersion: " + this._swVersion;
                SMS_Worker.SendMessage(phoneNumber, message);
            } else if (message.toLowerCase().indexOf("info") != -1) {
                message = "Info:\r\n";
                for (int i = 0; i < this._alertUsers.size(); ++i) {
                    message = message + i + "# AlertNr: " + this._alertUsers.elementAt(i) + "\r\n";
                }
                Logger.info(this.getClass(), "Info-String lenght = " + message.length());
                if (message.length() < 140) {
                    SMS_Worker.SendMessage(phoneNumber, message);
                } else {
                    while (message.length() > 140) {
                        String temp = message.substring(0, 130);
                        SMS_Worker.SendMessage(phoneNumber, temp);
                        message = message.substring(130);
                    }
                    SMS_Worker.SendMessage(phoneNumber, message);
                }
            } else if (message.toLowerCase().indexOf("config:") != -1) {
                int posEnd;
                int posStart2 = message.toLowerCase().indexOf("apn:");
                if (posStart2 != -1) {
                    posEnd = message.indexOf(";", posStart2);
                    this._apn = message.substring(posStart2 + 4, posEnd);
                    this._apn = this._apn.trim();
                    System.out.println("apn:" + this._apn);
                }
                if ((posStart2 = message.indexOf("user:")) != -1) {
                    posEnd = message.indexOf(";", posStart2);
                    this._username = message.substring(posStart2 + 5, posEnd);
                    this._username = this._username.trim();
                    System.out.println("user:" + this._username);
                }
                if ((posStart2 = message.indexOf("passwd:")) != -1) {
                    posEnd = message.indexOf(";", posStart2);
                    this._password = message.substring(posStart2 + 7, posEnd);
                    this._password = this._password.trim();
                    System.out.println("passwd:" + this._password);
                }
                if ((posStart2 = message.indexOf("number:")) != -1) {
                    posEnd = message.indexOf(";", posStart2);
                    this._gsmNumber = message.substring(posStart2 + 7, posEnd);
                    this._gsmNumber = this._gsmNumber.trim();
                    System.out.println("number:" + this._gsmNumber);
                }
                this.SaveConfiguration();
            } else if (message.toLowerCase().indexOf("getoperationtime") != -1) {
                int second = 1;
                int minute = second * 60;
                int hour = minute * 60;
                int day = hour * 24;
                boolean messageStarted = false;
                message = "Operation time counter: ";
                long counter = this._secondsOfOperation;
                if (counter > (long)day) {
                    message = message + Long.toString(counter / (long)day) + " day(s), ";
                    counter %= (long)day;
                    messageStarted = true;
                }
                if (counter > (long)hour || messageStarted) {
                    message = message + Long.toString(counter / (long)hour) + " hour(s), ";
                    counter %= (long)hour;
                    messageStarted = true;
                }
                if (counter > (long)minute || messageStarted) {
                    message = message + Long.toString(counter / (long)minute) + " minute(s), ";
                    counter %= (long)minute;
                }
                message = message + Long.toString(counter / (long)second) + " second(s)";
                SMS_Worker.SendMessage(phoneNumber, message);
            } else if (message.toLowerCase().indexOf("resetoperationtime") != -1) {
                this._secondsOfOperation = 0;
                message = "Operation time counter reseted.";
                SMS_Worker.SendMessage(phoneNumber, message);
                this.SaveConfiguration();
            } else if (message.toLowerCase().indexOf("firmware") != -1) {
                message = "Firmware = " + this._sms_worker.get_fw_version();
                message = message + "Free Memory: " + Runtime.getRuntime().freeMemory();
                message = message + "\r\nTotal Memory: " + Runtime.getRuntime().totalMemory();
                SMS_Worker.SendMessage(phoneNumber, message);
            } else if (message.toLowerCase().indexOf("network") != -1) {
                message = this._sms_worker.get_network_info();
                int pos = message.indexOf("chann");
                if (pos != -1) {
                    SMS_Worker.SendMessage(phoneNumber, message.substring(pos, pos + 159));
                }
            } else if (message.toLowerCase().indexOf("get operators") != -1) {
                message = "Operators: " + this._sms_worker.get_operator_information();
                SMS_Worker.SendMessage(phoneNumber, message);
            } else if (message.toLowerCase().indexOf("set operatorid") != -1 && (posStart = message.indexOf(":")) != -1) {
                int posEnd = message.indexOf(";", posStart);
                if (posEnd == -1) {
                    posEnd = message.indexOf(10, posStart);
                }
                if (posEnd != -1) {
                    String operatorId = message.substring(posStart + 4, posEnd);
                    operatorId = operatorId.trim();
                    message = "Status: " + this._sms_worker.select_operator(operatorId);
                    SMS_Worker.SendMessage(phoneNumber, message);
                } else {
                    SMS_Worker.SendMessage(phoneNumber, "failed");
                }
            }
        }
        catch (Exception excp) {
            SMS_Worker.SendMessage(phoneNumber, "SKPModem.SMS_ReceivedEvent" + excp.toString());
            excp.printStackTrace();
        }
    }

    public static MainThread GetInstance() {
        return _instance;
    }

    public MainThread() {
        this.WATCHDOG_TIME = 300;
        this.INIT_TIME = 10;
        this.INPUT_ERROR = 5;
        this.INPUT_NEARLY_FULL = 6;
        this.INPUT_FULL = 7;
        this.INPUT_OPERATION = 10;
        this.MIN_FRAME_SIZE = 6;
        _instance = this;
    }

    public String GetSIMCardNumber() {
        return this._sms_worker.GetSIMCardIdentificationNumber();
    }

    private boolean send_message(String msg) {
        int length = msg.length();
        byte chk = 0;
        byte[] send_data = new byte[length + 6];
        try {
            send_data[0] = 2;
            send_data[1] = 67;
            send_data[2] = (byte)((length & 0xFF00) >> 8);
            send_data[3] = (byte)(length & 0xFF);
            System.arraycopy(msg.getBytes(), 0, send_data, 4, length);
            for (int i = 0; i < length + 4; ++i) {
                chk = (byte)(chk + send_data[i]);
            }
            send_data[length + 4] = chk;
            send_data[length + 5] = 3;
            this._os.write(send_data);
        }
        catch (IOException excp) {
            Logger.error(this.getClass(), "Mainthread: " + excp.getMessage());
            return false;
        }
        return true;
    }

    private boolean AlertSMSReciptients(String strRecipients) {
        int posStart = 0;
        int posEnd = 0;
        this._alertUsers.removeAllElements();
        try {
            while ((posEnd = strRecipients.indexOf(";", posStart)) != -1) {
                String value = strRecipients.substring(posStart, posEnd);
                this._alertUsers.addElement(value);
                String smsMessage = this._stationId + ": ";
                smsMessage = smsMessage + this._msg[this._actualMsgId - 1];
                SMS_Worker.SendMessage(value, smsMessage);
                posStart = posEnd + 1;
            }
        }
        catch (Exception excp) {
            Logger.error(this.getClass(), excp.getMessage());
            excp.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean processMessages() {
        int offset = 0;
        int timeout = 0;
        int data_length = 0;
        boolean bFrameValid = false;
        boolean retval = true;
        do {
            int len;
            block24: {
                try {
                    len = this._is.available();
                    if (len <= 0) break block24;
                    this._is.read(this._indata, offset, len);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                    break;
                }
            }
            if ((offset += len) >= 6 && this._indata[0] == 2 && this._indata[offset - 1] == 3) {
                data_length = (this._indata[2] & 0xFF) << 8 | this._indata[3] & 0xFF;
                Logger.info(this.getClass(), "Datalength: " + data_length + "offset: " + offset);
                bFrameValid = true;
                break;
            }
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                // empty catch block
            }
        } while (timeout++ < 500);
        if (bFrameValid) {
            if (this._indata[1] == 64) {
                Logger.info(this.getClass(), "Received quit comand from server!");
                retval = false;
            } else if (this._indata[1] == 65) {
                String strCommand = new String(this._indata, 4, data_length);
                Logger.info(this.getClass(), "Received new command: " + strCommand);
                if (strCommand.startsWith("#ALR=")) {
                    int posStart = 0;
                    int posEnd = 0;
                    int num_values = 0;
                    String strNewConfig = strCommand.substring(5);
                    String value = "";
                    String strNewDate = "";
                    String strNewTime = "";
                    while ((posEnd = strNewConfig.indexOf(",", posStart)) != -1) {
                        value = strNewConfig.substring(posStart, posEnd);
                        if (++num_values == 1) {
                            strNewDate = value;
                            Logger.info(this.getClass(), "Date: " + value);
                        } else if (num_values == 2) {
                            strNewTime = value;
                            Logger.info(this.getClass(), "Time: " + value);
                        } else if (num_values == 3) {
                            this._stationId = value;
                            Logger.info(this.getClass(), "StationId: " + value);
                        } else if (num_values == 4) {
                            this._msg[this._actualMsgId - 1] = value;
                            Logger.info(this.getClass(), "Message: " + value);
                        } else if (num_values == 5) {
                            Logger.info(this.getClass(), "Recipients: " + value);
                            this.AlertSMSReciptients(value);
                        }
                        posStart = posEnd + 1;
                    }
                    String strDateTime = "";
                    strDateTime = strDateTime + strNewDate.substring(6, 8) + "/";
                    strDateTime = strDateTime + strNewDate.substring(2, 4) + "/";
                    strDateTime = strDateTime + strNewDate.substring(0, 2) + ",";
                    strDateTime = strDateTime + strNewTime.substring(0, 2) + ":";
                    strDateTime = strDateTime + strNewTime.substring(2, 4) + ":";
                    strDateTime = strDateTime + strNewTime.substring(4, 6);
                    System.out.println("Set new date and time to: " + strDateTime);
                    MainThread.GetInstance().SaveConfiguration();
                }
            }
        } else if (offset == 0) {
            Logger.info(this.getClass(), "No messages received. Hangup");
            retval = false;
        } else {
            String strCommand = new String(this._indata, 4, offset - 4);
            Logger.info(this.getClass(), "Invalid message with length: " + offset);
            Logger.info(this.getClass(), "Datalength: " + data_length + "offset: " + offset);
            Logger.info(this.getClass(), strCommand);
            retval = false;
        }
        return retval;
    }

    private boolean doAlerting() {
        boolean retval = true;
        int retry = 0;
        while (true) {
            try {
                StringBuffer profile = new StringBuffer(128);
                profile.append("socket://" + this._destHost + ":" + this._destPort);
                profile.append(";bearer_type=gprs");
                profile.append(";access_point=");
                profile.append(this._apn);
                profile.append(";username=");
                profile.append(this._username);
                profile.append(";password=");
                profile.append(this._password);
                profile.append(";timeout=70;");
                String openParam = profile.toString();
                Logger.info(this.getClass(), "Connector open: " + openParam);
                this._sc = (SocketConnection)Connector.open((String)openParam, (int)3, (boolean)true);
                this._sc.setSocketOption((byte)0, 0);
                Logger.info(this.getClass(), "Host: " + this._sc.getAddress() + " connected to: " + this._sc.getLocalAddress());
                Logger.info(this.getClass(), "ReceiveBufferSize: " + this._sc.getSocketOption((byte)3) + " SendBufferSize: " + this._sc.getSocketOption((byte)4));
                this._is = this._sc.openInputStream();
                this._os = this._sc.openOutputStream();
            }
            catch (IOException e) {
                Logger.error(this.getClass(), e.getMessage());
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException e2) {
                    Logger.error(this.getClass(), "Mainthread: " + e2.getMessage());
                }
                if (retry++ <= 5) continue;
            }
            break;
        }
        if (retry < 5) {
            String message = "%ALR=";
            message = message + this.GetSIMCardNumber() + ",";
            message = message + this._actualMsgId + ",";
            message = message + this._secondsOfOperation + ",";
            message = message + this._swVersion + ",";
            message = message + this._sms_worker.get_signal_quality() + ",";
            message = message + this._sms_worker.get_network_info();
            Logger.info(this.getClass(), "Sending message to server: " + message);
            this.send_message(message);
            retry = 0;
            if (this.processMessages()) {
                Logger.info(this.getClass(), "Message delivered successfully");
            } else {
                Logger.error(this.getClass(), "Message delivery failed -> send sms to stored recipients!");
                for (int i = 0; i < this._alertUsers.size(); ++i) {
                    String smsMessage = this._stationId + ": ";
                    smsMessage = smsMessage + this._msg[this._actualMsgId - 1];
                    SMS_Worker.SendMessage(this._alertUsers.elementAt(i).toString(), smsMessage);
                }
            }
        }
        try {
            if (this._is != null) {
                this._is.close();
            }
        }
        catch (Exception excp) {
            Logger.error(this.getClass(), "Exception: " + excp.getMessage() + ", while trying to close input stream");
            retval = false;
        }
        try {
            if (this._os != null) {
                this._os.close();
            }
        }
        catch (Exception excp) {
            Logger.error(this.getClass(), "Exception: " + excp.getMessage() + ", while trying to close output stream");
            retval = false;
        }
        try {
            if (this._sc != null) {
                this._sc.close();
            }
        }
        catch (Exception excp) {
            Logger.error(this.getClass(), "Exception: " + excp.getMessage() + ", while trying to close socket sonnection");
            retval = false;
        }
        return retval;
    }

    public void startApp() throws MIDletStateChangeException {
        this._time_last_boot = System.currentTimeMillis();
        this._watchdog.start(300);
        this._swVersion = this.getAppProperty("MIDlet-Version");
        System.out.println("Midlet-Version: " + this._swVersion);
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        System.out.println("Free memory: " + free + ", total memory: " + total);
        if (!this.LoadConfiguration()) {
            System.out.println("Error while trying to load configuration file!");
        }
        this._sms_worker = new SMS_Worker("0706");
        this._sms_worker.RegisterSMS_Receiver(this);
        this._sms_worker.start();
        this._ioController = new InputOutput();
        this._ioController.Initialize();
        try {
            long tErrorInputSet = 0L;
            long tNearlyFullInputSet = 0L;
            long tFullInputSet = 0L;
            long tOperationInputSet = 0L;
            long tInitTime = System.currentTimeMillis();
            do {
                try {
                    long time = System.currentTimeMillis();
                    if (time - tInitTime < 10000L) continue;
                    if (!InputOutput.GetInput(5)) {
                        if (tErrorInputSet == 0L) {
                            Logger.info(this.getClass(), "Error input set detected");
                            tErrorInputSet = time;
                            this._actualMsgId = 1;
                            this.doAlerting();
                        }
                    } else if (time - tErrorInputSet > 10000L && tErrorInputSet != 0L) {
                        Logger.info(this.getClass(), "Error input has gone for sure");
                        tErrorInputSet = 0L;
                    }
                    if (!InputOutput.GetInput(6)) {
                        if (tNearlyFullInputSet == 0L) {
                            Logger.info(this.getClass(), "Nearly full input set detected");
                            tNearlyFullInputSet = time;
                            this._actualMsgId = 2;
                            this.doAlerting();
                        }
                    } else if (time - tNearlyFullInputSet > 10000L && tNearlyFullInputSet != 0L) {
                        Logger.info(this.getClass(), "Nearly full input has gone for sure");
                        tNearlyFullInputSet = 0L;
                    }
                    if (!InputOutput.GetInput(7)) {
                        if (tFullInputSet == 0L) {
                            Logger.info(this.getClass(), "Full input set detected");
                            tFullInputSet = time;
                            this._actualMsgId = 3;
                            this.doAlerting();
                        }
                    } else if (time - tFullInputSet > 10000L && tFullInputSet != 0L) {
                        Logger.info(this.getClass(), "Full input has gone for sure");
                        tFullInputSet = 0L;
                    }
                    if (!InputOutput.GetInput(10)) {
                        if (tOperationInputSet == 0L) {
                            Logger.info(this.getClass(), "Operating input set detected");
                            tOperationInputSet = time;
                        }
                    } else if (tOperationInputSet != 0L) {
                        long operationSeconds = (time - tOperationInputSet) / 1000L;
                        this._secondsOfOperation = (int)((long)this._secondsOfOperation + operationSeconds);
                        this.SaveConfiguration();
                        tOperationInputSet = 0L;
                    }
                }
                catch (Exception ex) {
                    Logger.info(this.getClass(), "Input: " + ex.getMessage());
                    ex.printStackTrace();
                }
                try {
                    this._watchdog.kick();
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Logger.info(this.getClass(), "Interrupted in mainthread: " + e.getMessage());
                    this._bBreak = true;
                }
            } while (!this._bBreak);
            Logger.info(this.getClass(), "Mainthread: Workerthread stopped!");
        }
        catch (Exception e) {
            Logger.info(this.getClass(), "Exception occured in mainthread: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void pauseApp() {
        System.out.println("pauseApp()");
    }

    public void destroyApp(boolean cond) {
        if (!this._bBreak) {
            Logger.info(this.getClass(), "Deactivate Watchdog");
            this._watchdog.start(0);
        }
        Logger.info(this.getClass(), "Destroy app: " + cond);
        if (this._sms_worker != null) {
            this._sms_worker.stop();
            try {
                this._sms_worker.join();
            }
            catch (InterruptedException e) {
                Logger.info(this.getClass(), e.getMessage());
            }
        }
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        Logger.info(this.getClass(), "Free memory: " + free + ", total memory: " + total);
        this.notifyDestroyed();
    }
}

