/*
 * Decompiled with CFR 0.152.
 */
package Modem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import javax.microedition.io.file.FileConnection;

public class Logger {
    public static final byte UNKNOWN = 0;
    public static final byte TRACE = 1;
    public static final byte DEBUG = 2;
    public static final byte INFO = 3;
    public static final byte WARNING = 4;
    public static final byte ERROR = 5;
    public static final byte FATAL = 6;
    public static final byte OFF = 0;
    public static final byte MODE_STDOUT = 1;
    public static final byte MODE_STREAM = 2;
    private static byte _mode = 1;
    private static byte _logLevel = (byte)3;
    private static String _prefix = "";
    private static String _postfix = "";
    private static SocketConnection _sc = null;
    private static FileConnection _fconn = null;
    private static InputStream _inStream = null;
    private static OutputStream _outStream = null;

    public static void setStream(OutputStream stream) {
        _outStream = stream;
        _mode = stream != null ? (byte)2 : (byte)1;
    }

    private static void saveSettings(String apn, String username, String password, String serverAddress, int serverPort) {
        try {
            FileConnection fconn = (FileConnection)Connector.open((String)"a:/debug.conf", (int)3);
            if (!fconn.exists()) {
                Logger.log((byte)3, "Logger", "Create debug configuration file");
                fconn.create();
            }
            fconn.close();
        }
        catch (IOException excp) {
            Logger.log((byte)5, "Logger", "Exception while trying to set persistence: " + excp.getMessage());
        }
    }

    public static boolean init() {
        return true;
    }

    public static boolean startLog2Net(String apn, String username, String password, String serverAddress, int serverPort, boolean bPersist) {
        try {
            StringBuffer profile = new StringBuffer(60);
            profile.append("socket://" + serverAddress + ":" + serverPort);
            profile.append(";bearer_type=gprs;access_point=");
            profile.append(apn);
            profile.append(";username=");
            profile.append(username);
            profile.append(";password=");
            profile.append(password);
            profile.append(";timeout=");
            profile.append(15);
            profile.append(';');
            String openParam = profile.toString();
            Logger.log((byte)3, "Logger", "Connector open: " + openParam);
            _sc = (SocketConnection)Connector.open((String)openParam, (int)3, (boolean)true);
            _sc.setSocketOption((byte)0, 0);
            _inStream = _sc.openInputStream();
            _outStream = _sc.openOutputStream();
            _postfix = "\r\n";
            Logger.setStream(_outStream);
            Logger.log((byte)3, "Logger", "Host: " + _sc.getAddress() + " connected to: " + _sc.getLocalAddress());
            Logger.log((byte)3, "Logger", "ReceiveBufferSize: " + _sc.getSocketOption((byte)3) + "SendBufferSize: " + _sc.getSocketOption((byte)4));
        }
        catch (Exception excp) {
            Logger.log((byte)5, "Logger startLog2Net", excp.getMessage());
            return false;
        }
        return true;
    }

    public static boolean stopLog2Net() {
        try {
            if (_sc != null) {
                if (_inStream != null) {
                    _inStream.close();
                }
                if (_outStream != null) {
                    _outStream.close();
                }
                if (_sc != null) {
                    _sc.close();
                }
            }
        }
        catch (Exception excp) {
            Logger.log((byte)5, "Logger stopLog2Net", excp.getMessage());
            return false;
        }
        return true;
    }

    public static boolean startLog2File(String path) {
        try {
            _fconn = (FileConnection)Connector.open((String)("file:///" + path), (int)3);
            if (_fconn.exists()) {
                _fconn.delete();
            }
            _fconn.create();
            _outStream = _fconn.openOutputStream();
            _postfix = "\n";
            Logger.setStream(_outStream);
        }
        catch (Exception excp) {
            Logger.log((byte)5, "Logger startLog2File", excp.getMessage());
            return false;
        }
        return true;
    }

    public static boolean stopLog2File() {
        try {
            if (_outStream != null) {
                _outStream.close();
            }
            if (_fconn != null) {
                _fconn.close();
            }
            _fconn = null;
        }
        catch (Exception excp) {
            Logger.log((byte)5, "Logger stopLog2Net", excp.getMessage());
            return false;
        }
        return true;
    }

    private static void out(String message) {
        switch (_mode) {
            case 1: {
                System.out.println(message);
                break;
            }
            case 2: {
                if (_outStream == null) break;
                try {
                    _outStream.flush();
                    _outStream.write((_prefix + message + _postfix).getBytes());
                    break;
                }
                catch (Exception excp) {
                    excp.printStackTrace();
                    _mode = 1;
                    _postfix = "";
                }
            }
        }
    }

    public static void log(byte level, String moduleName, String message) {
        if (level < _logLevel) {
            return;
        }
        String logMessage = "";
        logMessage = System.currentTimeMillis() + " ";
        if (level == 1) {
            logMessage = logMessage + " T ";
        } else if (level == 2) {
            logMessage = logMessage + " D ";
        } else if (level == 3) {
            logMessage = logMessage + " I ";
        } else if (level == 4) {
            logMessage = logMessage + " W ";
        } else if (level == 5) {
            logMessage = logMessage + " E ";
        } else if (level == 6) {
            logMessage = logMessage + " ! ";
        }
        logMessage = logMessage + " " + moduleName + " : " + message;
        Logger.out(logMessage);
    }

    public static void trace(Class clazz, String message) {
        if (_logLevel > 1) {
            return;
        }
        String logMessage = "";
        logMessage = System.currentTimeMillis() + " ";
        logMessage = logMessage + " T ";
        logMessage = logMessage + " " + clazz.getName() + " : " + message;
        Logger.out(logMessage);
    }

    public static void debug(Class clazz, String message) {
        if (_logLevel > 2) {
            return;
        }
        String logMessage = "";
        logMessage = System.currentTimeMillis() + " ";
        logMessage = logMessage + " D ";
        logMessage = logMessage + " " + clazz.getName() + " : " + message;
        Logger.out(logMessage);
    }

    public static void info(Class clazz, String message) {
        if (_logLevel > 3) {
            return;
        }
        String logMessage = "";
        logMessage = System.currentTimeMillis() + " ";
        logMessage = logMessage + " I ";
        logMessage = logMessage + " " + clazz.getName() + " : " + message;
        Logger.out(logMessage);
    }

    public static void warning(Class clazz, String message) {
        if (_logLevel > 4) {
            return;
        }
        String logMessage = "";
        logMessage = System.currentTimeMillis() + " ";
        logMessage = logMessage + " W ";
        logMessage = logMessage + " " + clazz.getName() + " : " + message;
        Logger.out(logMessage);
    }

    public static void error(Class clazz, String message) {
        if (_logLevel > 5) {
            return;
        }
        String logMessage = "";
        logMessage = System.currentTimeMillis() + " ";
        logMessage = logMessage + " E ";
        logMessage = logMessage + " " + clazz.getName() + " : " + message;
        Logger.out(logMessage);
    }

    public static void fatal(Class clazz, String message) {
        if (_logLevel > 6) {
            return;
        }
        String logMessage = "";
        logMessage = System.currentTimeMillis() + " ";
        logMessage = logMessage + " ! ";
        logMessage = logMessage + " " + clazz.getName() + " : " + message;
        Logger.out(logMessage);
    }
}

