/*
 * Decompiled with CFR 0.152.
 */
package Modem;

import com.cinterion.io.ATCommand;
import com.cinterion.io.ATCommandFailedException;
import com.cinterion.io.ATCommandListener;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class InputOutput {
    private ATListener lt = null;
    private ATCommand ATCmd = null;
    private String config_filename = "file:///A:/io.config";
    private String inputport = "5,6,7,10";
    private String inputport_id = "";
    private String outputport = "";
    private String outputport_id = "";
    private String analoginput_readintervall = "1000";
    private final int number_of_analog_inputs;
    private final boolean use_input_position;
    private static short digi_inputs;
    private short digi_outputs;
    private AnalogInput[] ana_input = null;

    private boolean load_configuration() {
        FileConnection fconn = null;
        InputStream is = null;
        int size_of_file = 0;
        int posStart = 0;
        int posEnd = 0;
        int posColon = 0;
        try {
            fconn = (FileConnection)Connector.open((String)this.config_filename);
            is = fconn.openInputStream();
            size_of_file = is.available();
            System.out.println("Read " + size_of_file + " bytes of io config file");
            byte[] cfg = new byte[size_of_file];
            is.read(cfg);
            String str_cfg = new String(cfg);
            while (posStart < size_of_file) {
                posEnd = str_cfg.indexOf("\r\n", posStart);
                if (posEnd == -1) {
                    posEnd = size_of_file;
                }
                String line = str_cfg.substring(posStart, posEnd);
                posColon = line.indexOf(":");
                String key = line.substring(0, posColon);
                String val = line.substring(posColon + 1, posEnd - posStart);
                if (key.compareTo("InputPort") == 0) {
                    this.inputport = val.trim();
                } else if (key.compareTo("OutputPort") == 0) {
                    this.outputport = val.trim();
                } else if (key.compareTo("AnalogInputReadIntervall") == 0) {
                    this.analoginput_readintervall = val.trim();
                }
                posStart = posEnd + 2;
            }
            is.close();
            fconn.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    public int GetAnalogInput(int channel) {
        this.ana_input[channel].value = (this.ana_input[channel].raw_value - this.ana_input[channel].offset) * this.ana_input[channel].amplification / 4096;
        return this.ana_input[channel].value;
    }

    public int GetScaledAnalogInput(int channel, int max_scale, boolean bCurrent) {
        int val = (this.ana_input[channel].raw_value - this.ana_input[channel].offset) * this.ana_input[channel].amplification / 4096;
        int retval = 0;
        if (bCurrent) {
            if (val < 800) {
                return -1;
            }
            if (val < 1000) {
                return retval;
            }
            retval = (val - 1000) * max_scale / 4000;
        } else {
            retval = val * max_scale / 5000;
        }
        return retval;
    }

    public static boolean GetInput(int number) {
        return (digi_inputs & 1 << number) == 1 << number;
    }

    public boolean GetOutput(int number) {
        return (this.digi_outputs & 1 << number) == 1 << number;
    }

    public void ClearOutput(int number) {
        this.digi_outputs = (short)(this.digi_outputs & ~(1 << number));
        try {
            String response = this.ATCmd.send("AT^SSIO=" + this.outputport_id + "," + this.digi_outputs + "\r");
            if (response.indexOf("ERROR") != -1) {
                System.out.println("Error while activating polling for input port. Response was: " + response);
            }
        }
        catch (ATCommandFailedException excp) {
            System.out.println(excp.getMessage());
        }
    }

    public void SetOutput(int number) {
        this.digi_outputs = (short)(this.digi_outputs | 1 << number);
        try {
            String response = this.ATCmd.send("AT^SSIO=" + this.outputport_id + "," + this.digi_outputs + "\r");
            if (response.indexOf("ERROR") != -1) {
                System.out.println("Error while activating polling for input port. Response was: " + response);
            }
        }
        catch (ATCommandFailedException excp) {
            System.out.println(excp.getMessage());
        }
    }

    public void Initialize() {
        int pos = 0;
        try {
            int posCRLF;
            String pin;
            int posEnd;
            String response = this.ATCmd.send("AT^SPIO=1\r");
            if (response.indexOf("ERROR") != -1) {
                System.out.println("Error while open general purpose io driver: response was: " + response);
            }
            if (this.inputport.compareTo("") != 0) {
                while (pos < this.inputport.length()) {
                    posEnd = this.inputport.indexOf(",", pos);
                    if (posEnd == -1) {
                        posEnd = this.inputport.length();
                    }
                    pin = this.inputport.substring(pos, posEnd);
                    response = this.ATCmd.send("AT^SCPIN=1," + pin + ",0\r");
                    if (response.indexOf("ERROR") != -1) {
                        System.out.println("Error while configuring pin:" + pin + " response was: " + response);
                    }
                    pos = posEnd + 1;
                }
                response = this.ATCmd.send("AT^SCPORT=" + this.inputport + "\r");
                pos = response.indexOf("^SCPORT:");
                if (pos != -1) {
                    posCRLF = response.indexOf("\r\n", pos);
                    this.inputport_id = response.substring(pos + 9, posCRLF);
                } else {
                    System.out.println("Error while extracting input port id\n");
                }
            }
            if (this.inputport_id.compareTo("") != 0) {
                response = this.ATCmd.send("AT^SCPOL=1," + this.inputport_id + "\r");
                if (response.indexOf("ERROR") != -1) {
                    System.out.println("Error while activating polling for input port. Response was: " + response);
                }
            } else {
                pos = 0;
                while (pos < this.inputport.length()) {
                    posEnd = this.inputport.indexOf(",", pos);
                    if (posEnd == -1) {
                        posEnd = this.inputport.length();
                    }
                    pin = this.inputport.substring(pos, posEnd);
                    response = this.ATCmd.send("AT^SCPOL=1," + pin + "\r");
                    if (response.indexOf("ERROR") != -1) {
                        System.out.println("Error while activating polling for pin:" + pin + " response was: " + response);
                    }
                    response = this.ATCmd.send("AT^SGIO=" + pin + "\r");
                    System.out.println("Input pin: " + pin + " response was: " + response);
                    if (response.indexOf("SGIO: 1") != -1) {
                        digi_inputs = (short)(digi_inputs | 1 << Short.parseShort(pin));
                        System.out.println("Current Digital input: " + digi_inputs);
                    }
                    pos = posEnd + 1;
                }
            }
            if ((pos = (response = this.ATCmd.send("AT^SGIO=" + this.inputport_id + "\r")).indexOf("^SGIO:")) != -1) {
                posCRLF = response.indexOf("\r\n", pos);
                String str_digi_in = response.substring(pos + 6, posCRLF);
                str_digi_in = str_digi_in.trim();
                digi_inputs = Short.parseShort(str_digi_in);
                System.out.println("Current Digital input: " + digi_inputs);
            }
            pos = 0;
            if (this.outputport.compareTo("") != 0) {
                while (pos < this.outputport.length()) {
                    posEnd = this.outputport.indexOf(",", pos);
                    if (posEnd == -1) {
                        posEnd = this.outputport.length();
                    }
                    pin = this.outputport.substring(pos, posEnd);
                    response = this.ATCmd.send("AT^SCPIN=1," + pin + ",1\r");
                    if (response.indexOf("ERROR") != -1) {
                        System.out.println("Error while configuring pin:" + pin + " response was: " + response);
                    }
                    pos = posEnd + 1;
                }
                response = this.ATCmd.send("AT^SCPORT=" + this.outputport + "\r");
                pos = response.indexOf("^SCPORT:");
                if (pos != -1) {
                    posCRLF = response.indexOf("\r\n", pos);
                    this.outputport_id = response.substring(pos + 9, posCRLF);
                } else {
                    System.out.println("Error while extrating output port id\n");
                }
            }
        }
        catch (ATCommandFailedException excp) {
            System.out.println(excp.getMessage());
        }
    }

    public void DeInitialize() {
        try {
            String pin;
            int posEnd;
            String response;
            int pos;
            if (this.inputport.compareTo("") != 0) {
                pos = 0;
                response = this.ATCmd.send("AT^SDPORT=" + this.inputport_id + "\r");
                if (response.indexOf("ERROR") != -1) {
                    System.out.println("Error while deleting input port id\n");
                }
                while (pos < this.inputport.length()) {
                    posEnd = this.inputport.indexOf(",", pos);
                    if (posEnd == -1) {
                        posEnd = this.inputport.length();
                    }
                    pin = this.inputport.substring(pos, posEnd);
                    response = this.ATCmd.send("AT^SCPIN=0," + pin + ",0\r");
                    if (response.indexOf("ERROR") != -1) {
                        System.out.println("Error while closing pin:" + pin + " response was: " + response);
                    }
                    pos = posEnd + 1;
                }
            }
            if (this.outputport.compareTo("") != 0) {
                pos = 0;
                response = this.ATCmd.send("AT^SDPORT=" + this.outputport_id + "\r");
                if (response.indexOf("ERROR") != -1) {
                    System.out.println("Error while deleting output port id\n");
                }
                while (pos < this.outputport.length()) {
                    posEnd = this.outputport.indexOf(",", pos);
                    if (posEnd == -1) {
                        posEnd = this.outputport.length();
                    }
                    pin = this.outputport.substring(pos, posEnd);
                    response = this.ATCmd.send("AT^SCPIN=0," + pin + ",0\r");
                    if (response.indexOf("ERROR") != -1) {
                        System.out.println("Error while closing pin:" + pin + " response was: " + response);
                    }
                    pos = posEnd + 1;
                }
            }
            if ((response = this.ATCmd.send("AT^SPIO=0\r")).indexOf("ERROR") != -1) {
                System.out.println("Error while open general purpose io driver: response was: " + response);
            }
        }
        catch (ATCommandFailedException excp) {
            System.out.println(excp.getMessage());
        }
    }

    public InputOutput() {
        this.number_of_analog_inputs = 0;
        this.use_input_position = true;
        try {
            this.lt = new ATListener();
            this.ATCmd = new ATCommand(false);
            this.ATCmd.addListener(this.lt);
            this.ana_input = new AnalogInput[2];
            this.ana_input[0] = new AnalogInput();
            this.ana_input[1] = new AnalogInput();
        }
        catch (ATCommandFailedException e) {
            System.out.println("InputOutput:" + e.getMessage());
        }
    }

    class ATListener
    implements ATCommandListener {
        ATListener() {
        }

        public void ATEvent(String Event) {
            block10: {
                try {
                    System.out.println("URC-Event: " + Event);
                    if (Event.indexOf("^SCPOL:") != -1) {
                        int posCR;
                        int posComma1;
                        int posColon = Event.indexOf(":");
                        if (posColon != -1 && (posComma1 = Event.indexOf(",", posColon)) != -1 && (posCR = Event.indexOf("\r\n", posColon)) != -1) {
                            int position = 0;
                            String str_digi_in = Event.substring(posComma1 + 1, posCR);
                            position = Integer.parseInt(Event.substring(posColon + 2, posComma1));
                            short input = Short.parseShort(str_digi_in);
                            if (input != 0) {
                                digi_inputs = (short)(digi_inputs | 1 << position);
                            } else {
                                digi_inputs = (short)(digi_inputs & ~(1 << position));
                            }
                            System.out.println("Digitalinputs changed: " + digi_inputs);
                        }
                        break block10;
                    }
                    if (Event.indexOf("^SRADC:") == -1) break block10;
                    try {
                        int posCR;
                        int posComma2;
                        int posComma1;
                        int posColon = Event.indexOf(":");
                        if (posColon != -1 && (posComma1 = Event.indexOf(",", posColon)) != -1 && (posComma2 = Event.indexOf(",", posComma1 + 1)) != -1 && (posCR = Event.indexOf("\r\n", posComma2)) != -1) {
                            String str_channel = Event.substring(posColon + 2, posComma1);
                            String str_count = Event.substring(posComma1 + 1, posComma2);
                            short count = Short.parseShort(str_count);
                            String str_value = Event.substring(posComma2 + 1, posCR);
                            short channel = Short.parseShort(str_channel);
                            if (count != 1 || channel < 0 || channel > 1) {
                                return;
                            }
                            ((InputOutput)InputOutput.this).ana_input[channel].raw_value = Short.parseShort(str_value);
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                catch (Exception excp) {
                    System.out.println(excp.getMessage());
                }
            }
        }

        public void RINGChanged(boolean SignalState) {
        }

        public void DCDChanged(boolean SignalState) {
            System.out.println("DCD-Event: " + SignalState);
        }

        public void DSRChanged(boolean SignalState) {
            System.out.println("DSR-Event: " + SignalState);
        }

        public void CONNChanged(boolean SignalState) {
            System.out.println("CONN-Event: " + SignalState);
        }
    }

    class AnalogInput {
        public int raw_value;
        public int offset;
        public int amplification;
        public int value;
        public int scaling;
        public int scaled_value;

        AnalogInput() {
        }

        void AnalogInput() {
            this.raw_value = 0;
            this.offset = 0;
            this.amplification = 0;
            this.value = 0;
            this.scaling = 0;
            this.scaled_value = 0;
        }
    }
}

