/*
 * Decompiled with CFR 0.152.
 */
package Modem;

import Modem.KeyValuePair;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class Configuration {
    static final String CONFIG_FILENAME = "file:///A:/app.config";
    private static Vector _settings;

    public static Vector load() {
        int posStart = 0;
        _settings = new Vector();
        try {
            FileConnection fconn = (FileConnection)Connector.open((String)CONFIG_FILENAME);
            InputStream fis = fconn.openInputStream();
            int size_of_file = fis.available();
            System.out.println("Read " + size_of_file + " bytes of config file");
            byte[] cfg = new byte[size_of_file];
            fis.read(cfg);
            String str_cfg = new String(cfg);
            while (posStart < size_of_file) {
                String line;
                int posColon;
                int posEnd = str_cfg.indexOf("\r\n", posStart);
                if (posEnd == -1) {
                    posEnd = size_of_file;
                }
                if ((posColon = (line = str_cfg.substring(posStart, posEnd)).indexOf(":")) != -1) {
                    String key = line.substring(0, posColon);
                    String value = line.substring(posColon + 1, posEnd - posStart);
                    KeyValuePair pair = new KeyValuePair(key, value);
                    _settings.addElement(pair);
                }
                posStart = posEnd + 2;
            }
            fis.close();
            fconn.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return null;
        }
        return _settings;
    }

    public static boolean save(Vector config) {
        try {
            FileConnection fconn = (FileConnection)Connector.open((String)CONFIG_FILENAME, (int)3);
            if (!fconn.exists()) {
                fconn.create();
            }
            OutputStream fos = fconn.openOutputStream();
            for (int i = 0; i < config.size(); ++i) {
                KeyValuePair entry = (KeyValuePair)config.elementAt(i);
                String line = entry.getKey() + ": " + entry.getValue() + "\r\n";
                fos.write(line.getBytes());
            }
            fos.close();
            fconn.close();
        }
        catch (IOException excp) {
            System.out.println(excp.getMessage());
            return false;
        }
        return true;
    }

    public static boolean save() {
        return Configuration.save(_settings);
    }

    public static String getValue(String key) {
        for (int i = 0; i < _settings.size(); ++i) {
            KeyValuePair pair = (KeyValuePair)_settings.elementAt(i);
            if (!key.toLowerCase().equals(pair.getKey().toLowerCase())) continue;
            return pair.getValue().trim();
        }
        return "";
    }

    public static boolean setValue(String key, String value) {
        for (int i = 0; i < _settings.size(); ++i) {
            KeyValuePair pair = (KeyValuePair)_settings.elementAt(i);
            if (!key.equals(pair.getKey().toLowerCase())) continue;
            pair.setValue(value);
            return true;
        }
        return false;
    }
}

